<?php

include '../c_leitura.php';
require_once dirname(__DIR__) . DIRECTORY_SEPARATOR . "sealed" . DIRECTORY_SEPARATOR . "autoload.php";
date_default_timezone_set($_SESSION['timezone']);

$nivel_necessario = 6;
if (!isset($_SESSION['UsuarioID']) OR ( $_SESSION['UsuarioNivel'] > $nivel_necessario)) {
// Destrói a sessão por segurança
    session_destroy();
// Redireciona o visitante de volta pro login
    header("Location: index.php");
    exit;
}

$argAction = array(
    'crud' => array(
        'filter' => FILTER_VALIDATE_REGEXP,
        'options' => array("regexp" => "/^(jogadores|get_jogador|set_creditos|out_creditos)$/")
    ),
    'creditos' => array(
        'filter' => FILTER_VALIDATE_INT
    ),
    'valor' => array(
        'filter' => FILTER_VALIDATE_INT
    )
);

$argsPost = array(
    'id' => array(
        'filter' => FILTER_VALIDATE_INT
    ),
    'username' => array(
        'filter' => FILTER_SANITIZE_STRING
    ),
    'nome' => array(
        'filter' => FILTER_SANITIZE_STRING
    ),
    'id_ponto' => array(
        'filter' => FILTER_SANITIZE_STRING
    ),
    'password' => array(
        'filter' => FILTER_SANITIZE_STRING
    ),
    'password2' => array(
        'filter' => FILTER_SANITIZE_STRING
    )
);
$inputAction = filter_input_array(INPUT_POST, $argAction);
$inputPOSTjogadores = filter_input_array(INPUT_POST, $argsPost);

switch ($inputAction['crud']) {
    case 'jogadores':
        if ($inputPOSTjogadores['password'] != $inputPOSTjogadores['password2']) {
            echo json_encode(array('success' => 0, 'msg' => 'Senhas digitadas estão diferentes!'));
            exit;
        } else {
            $inputPOSTjogadores['password'] = FUNCOES::cryptografar($inputPOSTjogadores['password']);
            if (empty($inputPOSTjogadores['id'])) {
                unset($inputPOSTjogadores['id']);
                unset($inputPOSTjogadores['password2']);
                $args = " j.username='" . $inputPOSTjogadores['username'] . "'";
                $jogador = jogadorDAO::getJogadores($args, false);
                if (empty($jogador)) {
                    $inputPOSTjogadores['user_id'] = $_SESSION['UsuarioID'];
                    jogadorDAO::salvar($inputPOSTjogadores, 'jogador');
                    echo json_encode(array('success' => 1, 'msg' => 'Cadastro realizado com sucesso!'));
                } else {
                    echo json_encode(array('success' => 0, 'msg' => 'Username já existente!!'));
                }
            } else {
                unset($inputPOSTjogadores['password2']);
                $inputPOSTjogadores['user_id'] = $_SESSION['UsuarioID'];
                jogadorDAO::salvar($inputPOSTjogadores, 'jogador', $inputPOSTjogadores['id']);
                echo json_encode(array('success' => 1, 'msg' => 'Registro salvo com sucesso!'));
            }
        }
        break;

    case 'get_jogador':
        $args = " j.id='" . $inputPOSTjogadores['id'] . "'";
        $jogador = jogadorDAO::getJogadores($args, false);
        $dado = array();
        $dado['jogador'] = $jogador;
        echo json_encode($dado);
        break;
}