<?php
include 'dbc.php';
class cobranca_agregadoDAO {

    function __construct() {
        
    }

    function __destruct() {
        //$this->banco = NULL;
    }

    public function __set($campo, $valor) {
        $this->$campo = $valor;
    }

    public function __get($campo) {
        return $this->$campo;
    }

    static function salvar($data, $table, $dbk = NULL) {
        try {
            $fields = $data;

            $tmp = array();
            foreach ($fields as $k => $v) {
                if ($k != $dbk) {
                    $tmp[] = $k . ' = :' . $k;
                }
            }
            if (isset($dbk)) {
                $fields['id'] = $dbk;
                $SQL = 'UPDATE ' . $table . ' SET ' . implode(', ', $tmp) . ' WHERE (id=:id)';
            } else {
                $SQL = 'INSERT INTO ' . $table . ' SET ' . implode(', ', $tmp);
            }
            $db = new DB();
            $id = $db->InsertData($SQL, $fields);
            return $id;
        } catch (Exception $ex) {
            throw new Exception($ex->getMessage() . ': ' . __FUNCTION__);
        }
    }

    static function getid_cliente($id_cobranca) {
        try {
            $sql = "SELECT id_cliente FROM cobranca_agregado WHERE id_cobranca =?";
            $db = new DB();
            return $db->executeReturnFetch($sql, array($id_cobranca));
        } catch (Exception $err) {
            throw new Exception($err->getMessage() . ': ' . __FUNCTION__);
        }
    }

    static function getid_cobrancas($id_cliente) {
        try {
            $array = array();
            $sql = "SELECT id_cobranca,id_cliente FROM cobranca_agregado "
            . " WHERE id_cliente =?"
            . " AND cobranca_fechada = 1";
            $db = new DB();
            $rows = $db->executeReturn_FETCH_ASSOC($sql, array($id_cliente), true);
            foreach ($rows as $row) {
                $array[id_cobranca][] = $row[id_cobranca];
                $array[id_cliente][] = $row[id_cliente];
            }
            return $array;
        } catch (Exception $err) {
            throw new Exception($err->getMessage() . ': ' . __FUNCTION__);
        }
    }

    static function getid_cobrancasCliente($id_cliente) {
        try {
            $array = array();
            $sql = "SELECT cp.id_cobranca FROM cobranca_ponto cp INNER JOIN ponto p ON p.id = cp.id_ponto "
            . " WHERE p.id_apoio = ?"
            . " AND cobranca_fechada = 1";
            $db = new DB();
            $rows = $db->executeReturn_FETCH_ASSOC($sql, array($id_cliente), true);
            foreach ($rows as $row) {
                $array[id_cobranca][] = $row[id_cobranca];
//                $array[id_cliente][] = $row[id_cliente];
            }
            return $array;
        } catch (Exception $err) {
            throw new Exception($err->getMessage() . ': ' . __FUNCTION__);
        }
    }

    static function getClientes($id_pontos) {
        try {
            $array = array();
            $sql = "SELECT p.id_apoio FROM cobranca_ponto cp"
            . " INNER JOIN ponto p ON p.id = cp.id_ponto "
            . " WHERE cp.id_ponto IN (" . implode(',', $id_pontos) . ")"
            . " AND cp.cobranca_fechada = 1"
            . " GROUP BY p.id_apoio";
            $db = new DB();
            $rows = $db->executeReturn_FETCH_ASSOC($sql, array($id_pontos), true);
            foreach ($rows as $row) {
                $array[id_cliente][] = $row[id_apoio];
            }
            return $array;
        } catch (Exception $err) {
            throw new Exception($err->getMessage() . ': ' . __FUNCTION__);
        }
    }

    public static function deletarUsuario($id) {
        try {
            $sql = 'DELETE FROM usuario'
            . ' WHERE id =' . $id;
            $db = new DB();
            $db->query($sql);
        } catch (Exception $err) {
            throw new Exception($err->getMessage() . ': ' . __CLASS__ . '*' . __FUNCTION__);
        }
    }

    static function getCobrancasSubUsers($id_apoio, $nivel) {
        try {
            $array = array();
            $sql = "SELECT id FROM user WHERE id_apoio=? $nivel";
            $db = new DB();
            $rows = $db->executeReturn_FETCH_ASSOC($sql, array($id_apoio), true);
            foreach ($rows as $key => $row) {
                $cobrancas = cobranca_agregadoDAO::getid_cobrancas($row[id]);
                if ($cobrancas[id_cobranca][$key]) {
                    $array[id_cobranca][] = $cobrancas[id_cobranca][$key];
                }
            }
            return $array;
        } catch (Exception $err) {
            throw new Exception($err->getMessage() . ': ' . __FUNCTION__);
        }
    }

}
